SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_Sp_DeleteRespondent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_Sp_DeleteRespondent]
GO
CREATE PROCEDURE [dbo].[VX_Sp_DeleteRespondent]
                @Quest VARCHAR(10)
AS
  IF @quest <> ''
    BEGIN
      DELETE FROM note
      WHERE       notrespondent = @Quest
      DELETE FROM historicResponse
      WHERE       Respondent = @Quest
      DELETE FROM ResponseModifLog
      WHERE       Respondent = @Quest
      DELETE FROM RespondentModifLog
      WHERE       Respondent = @Quest

	  --Clean CaseActionHistory and CaseActionHistoryDetail tables
	  SELECT ActionId, ActionDetailId 
	  INTO #tempCaseActionHistoryDetail
	  FROM CaseActionHistoryDetail
	  WHERE CaseId = @Quest

	  DELETE FROM CaseActionHistoryDetail
	  WHERE ActionDetailId in (Select ActionDetailId FROM #tempCaseActionHistoryDetail)

	  UPDATE CAH
	  SET CAH.CaseCount = CAHD.CaseCount
	  FROM CaseActionHistory CAH
 	  JOIN (Select	ActionId, 
					COUNT(ActionDetailId) AS CaseCount 
					FROM CaseActionHistoryDetail
					GROUP BY ActionId) CAHD	ON  CAHD.ActionId = CAH.ActionId
	  WHERE CAH.ActionId in (SELECT DISTINCT ActionId FROM #tempCaseActionHistoryDetail)

      DELETE FROM historic
      WHERE       hisrespondent = @Quest
      DELETE FROM stratum
      WHERE       strrespondent = @Quest
      DELETE FROM timeslothit
      WHERE       tshrespondent = @Quest
      DELETE FROM response
      WHERE       rpsrespondent = @Quest
      DELETE FROM respondent
      WHERE       resrespondent = @Quest
      DELETE FROM IS_RespondentSync 
      WHERE       CCRespondentId = @Quest

END
